#ifndef __CApplication__
#define __CApplication__

#include "../Basics/CSystemString.hpp"
using Exponent::Basics::CSystemString;

//	===========================================================================

/**
 * @cond
 */
#ifndef __IWINDOW_GUARD__
#define __IWINDOW_GUARD__
	namespace Exponent { namespace GUI { namespace Windowing { interface IWindow; } } }
	using Exponent::GUI::Windowing::IWindow;
#endif
/**
 * @endcond
 */

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CApplication CApplication.hpp
		 * @brief Stores information about the applicaton
		 *
		 * Stores information about the applicaton, and provides ways to start\n
		 * and end the application gracefully in the normal way...
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.1.0 Made all windows identifiers (HINSTANCE and the like) static, cos you cant really have more than one!
		 * @version 1.2.0 Made all identifiers static, same reason as above
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CApplication.hpp,v 1.6 2007/02/11 02:15:54 paul Exp $
		 */
		class CApplication
		{
		public:

//	===========================================================================
/** @cond */
#ifdef WIN32
/** @endcond */

			/**
			 * Store the HINSTANCE
			 * @param instance The windows application instance
			 */
			static void setApplicationInstance(HINSTANCE instance) { CAPPLICATION_INSTANCEHANDLE = instance; }

			/**
			 * Store the applications window handle
			 * @param windowHandle The application window handle
			 */
			static void setApplicationWindowHandle(HWND windowHandle) { CAPPLICATION_WINDOWHANDLE = windowHandle; }

			/**
			 * Store the applications module handle
			 * @param moduleInstance The instance of the module
			 */
			static void setApplicationModuleHandle(HMODULE moduleInstance) { CAPPLICATION_MODULEHANDLE = moduleInstance; }

			/**
			 * Get the HINSTANCE
			 * @retval HINSTANCE The Windows application instance
			 */
			static HINSTANCE getApplicationInstance() { return CAPPLICATION_INSTANCEHANDLE; }

			/**
			 * Get the application window handle
			 * @retval HWND The window handle
			 */
			static HWND getApplicationWindowHandle() { return CAPPLICATION_WINDOWHANDLE; }

			/**
			 * Get the module handle
			 * @retval HMODULE The module handle
			 */
			static HMODULE getApplicationModuleHandle() { return CAPPLICATION_MODULEHANDLE; }

			/**
			 * Get the current module file name
			 * @param filename On returns stores the name of the executable being run
			 * @note Doesnt work for DLL's and the like
			 * @see getModuleFileName
			 */
			static void getCurrentExecutableFileName(CString &filename);

			/**
			 * Get the current module file name
			 * @param filename On returns stores the name of the module being run
			 * @note Doesnt work for executables
			 * @see getCurrentExecutableFileName
			 */
			static void getModuleFileName(CString &filename);
/** @cond */
#else
/** @endcond */

			/**
			 * Store the HINSTANCE
			 * @param instance The mac application instance (java form)
			 */
			static void setApplicationInstance(const CString &instance) { CAPPLICATION_INSTANCEHANDLE = instance; }

			/**
			 * Store the applications module handle
			 * @param moduleInstance The instance of the module
			 */
			static void setApplicationModuleHandle(const CString &moduleInstance) { CAPPLICATION_MODULEHANDLE = moduleInstance; }

			/**
			 * Get the application instance
			 * @retval const CString& The mac application instance
			 */
			static const CString &getApplicationInstance() { return CAPPLICATION_INSTANCEHANDLE; }

			/**
			 * Get the module handle
			 * @retval  const CString& The mac module handle
			 */
			static const CString &getApplicationModuleHandle() { return CAPPLICATION_MODULEHANDLE; }
/** @cond */
#endif
/** @endcond */

//	===========================================================================

			/**
			 * Run the application
			 * @retval unsigned long On windoes machines a result code from the message\n
			 * loop. On mac return is always 0
			 */
			static unsigned long runApplicationEventLoop();

			/**
			 * Stop the application. Exits normally.
			 */
			static void stopApplicationEventLoop();

//	===========================================================================

			/**
			 * Set hte application name
			 * @param applicationName The name of the application
			 */
			static void setApplicationName(const CString &applicationName);

			/**
			 * Set the application developer
			 * @param applicationDeveloper The developer of the application
			 */
			static void setApplicationDeveloper(const CString &applicationDeveloper);

			/**
			 * Set the application version
			 * @param applicationVersion The version of the application
			 */
			static void setApplicationVersion(const CString &applicationVersion);

			/**
			 * Set the copyright information
			 * @param applicationCopyRight Arbitrary string that can say anything you want
			 */
			static void setApplicationCopyrightInformation(const CString &applicationCopyRight);

			/**
			 * Set the application description
			 * @param applicationDescription The application description
			 */
			static void setApplicationDescription(const CString &applicationDescription);

			/**
			 * Set the application install path
			 * @param path The install path of the application
			 */
			static void setApplicationInstallPath(const CSystemString &path);

			/**
			 * Set the application install path, based on the module handle
			 */
			static void setApplicationInstallPathFromApplicationHandle();

			/**
			 * Set the application main window
			 * @param window The application main window
			 * @note IMPORTANT! THIS DOES NOT INCREMENT THE REFERENCE COUNT OF THE WINDOW!\n
			 * The window is stored as a pointer manually. It will never be accessed by this class and is used solely to check for the validity\n
			 * of automagic system shutdown\n
			 * It should be noted that this will only work on windows based systems, macs are tied to the menu system and windows can be opened and closed at will...
			 * @see EGUI::Windowing::CWindow::windowClosed
			 */
			static void setApplicationWindow(IWindow *window);

			/**
			 * Set the application registry path
			 * @param path The registry path
			 */
			static void setApplicationRegistry(const CString &path);

//	===========================================================================

			/**
			 * Get the application name
			 * @retval const CString& The application name
			 */
			static const CString &getApplicationName();

			/**
			 * Get the application developer
			 * @retval const CString& The application developer
			 */
			static const CString &getApplicationDeveloper();

			/**
			 * Get the application version
			 * @retval const CString& The application version
			 */
			static const CString &getApplicationVersion();

			/**
			 * Get the application copyright
			 * @retval const CString& The application copyright
			 */
			static const CString &getApplicationCopyrightInformation();

			/**
			 * Get the application product description
			 * @retval const CString& A description of the product
			 */
			static const CString &getApplicationDescription();

			/**
			 * Get the application install path
			 * @retval const CSystemString& The install path of the module
			 */
			static const CSystemString &getApplicationInstallPath();

			/**
			 * Get the main application window
			 * @retval const IWindow* The Application main window
			 */
			static const IWindow *getApplicationWindow();

			/**
			 * Get the application registry path
			 * @retval const CString& The registry path
			 */
			static const CString &getApplicationRegistry();

//	===========================================================================

		protected:

//	===========================================================================
/** @cond */
#ifdef WIN32
/** @endcond */
			static HINSTANCE CAPPLICATION_INSTANCEHANDLE;		/**< the instance of the application */
			static HMODULE CAPPLICATION_MODULEHANDLE;			/**< the instance of the module */
			static HWND CAPPLICATION_WINDOWHANDLE;				/**< the window handle */
/** @cond */
#else
/** @endcond */
			static CString CAPPLICATION_INSTANCEHANDLE;			/**< Java form com.exponent.balh.foo */
			static CString CAPPLICATION_MODULEHANDLE;			/**< Java form com.exponent.balh.foo */
/** @cond */
#endif
/** @endcond */
			static CString CAPPLICATION_NAME;					/**< Name of app */
			static CString CAPPLICATION_DEVELOPER;				/**< Name of the developer */
			static CString CAPPLICATION_VERSION;				/**< Version of the app */
			static CString CAPPLICATION_COPYRIGHT;				/**< Copyright of the app */
			static CString CAPPLICATION_PRODUCT;				/**< Description of the product */
			static CString CAPPLICATION_REGISTRY;				/**< Registry of the product */
			static CSystemString CAPPLICATION_INSTALL_PATH;		/**< Where is the application installed */

			static IWindow *CAPPLICATION_WINDOW;				/**< Application window */
		};
	}
}
#endif	// End of CApplication.hpp